<?php
if(1){
	$meg = "Usage: php car.php [option] <.coords file> [-r <reference.fna file>, -q <draft.fna file>]";
	$meg_h = "Using '-h' for help";
	foreach($argv as $k => $each){
		if(strstr($each, ".coords")){
			$coords = $each;
			if(!file_exists($each)){
				die("$meg\n$meg_h\n");
			}
		}
		else if($each == "-r"){
			$ref = $argv[$k+1];
			if(!file_exists($ref)){
				die("$meg\n$meg_h\n");
			}
		}
		else if($each == "-q"){
			$multiFasta = $argv[$k+1];
			if(!file_exists($multiFasta)){
				die("$meg\n$meg_h\n");
			}
		}
		else if(strstr($each, "-h")){
			print "$meg\n";
			print "Option: \n";
		//	print "-a     imply -nuc -d\n";
			print "-d     draw dotplot (MUMmer is required, -m would be applied automatically)\n";
		//	print "-dist  show rearrangement distance between reference and draft genome\n";
			print "-h     help message\n";
			print "-m     generate a multi-fasta file for the ordered contigs\n";
			print "-nuc   run NUCmer to generate .coords file (MUMmer is required)\n";
			print "-pro   run PROmer to generate .coords file (MUMmer is required)\n";
			print "-r     parameter for reference fasta file\n";
			print "-unmap generate a multi-fasta file for unmapped contigs (-r <reference> -q <draft> as input is necessary)\n";
			print "-q     parameter for draft fasta file\n";
			exit();
		}
		else if($each == "-d"){
			$dotplot = 1;
			$showMultiFASTA = 1;
		}
		else if($each == "-m"){
			$showMultiFASTA = 1;
		}
		else if($each == "-ro"){
			$random_order = 1;
		}
		else if($each == "-re"){
			$reverse_order = 1;
			$answer = $argv[$k+1];
			if(!file_exists($answer)){
				die("$meg\n$meg_h\n");
			}
		}
		else if($each == "-nuc"){
			$nucRun = 1;
			$mum = 1;
		}
		else if($each == "-pro"){
			$proRun = 1;
			$mum = 1;
		}
		else if($each == "-dist"){
			$countDist = 1;
		}
		else if($each == "-unmap"){
			$unmappedFile = 1;
		}
	}

	if(isset($nucRun)){
		if(strstr($multiFasta, "/")){
			$multiFastaCurrentPath = substr($multiFasta, strrpos($multiFasta, "/")+1);
		}
		else{
			$multiFastaCurrentPath = $multiFasta;
		}
		system("nucmer $ref $multiFasta -p $multiFastaCurrentPath.nuc");
	//	system("delta-filter -1 $multiFastaCurrentPath.nuc.delta > $multiFastaCurrentPath.nuc.filter"); // parameter "-1" has some bugs
		system("delta-filter -r -q $multiFastaCurrentPath.nuc.delta > $multiFastaCurrentPath.nuc.filter");
		system("show-coords -l -d $multiFastaCurrentPath.nuc.filter > $multiFastaCurrentPath.nuc.coords");
		$coords = "$multiFastaCurrentPath.nuc.coords";
	}
	else if(isset($proRun)){
		if(strstr($multiFasta, "/")){
			$multiFastaCurrentPath = substr($multiFasta, strrpos($multiFasta, "/")+1);
		}
		else{
			$multiFastaCurrentPath = $multiFasta;
		}
		system("promer $ref $multiFasta -p $multiFastaCurrentPath.pro");
	//	system("delta-filter -1 $multiFastaCurrentPath.pro.delta > $multiFastaCurrentPath.pro.filter");
		system("delta-filter -r -q $multiFastaCurrentPath.pro.delta > $multiFastaCurrentPath.pro.filter");
		system("show-coords -l -d $multiFastaCurrentPath.pro.filter > $multiFastaCurrentPath.pro.coords");
		$coords = "$multiFastaCurrentPath.pro.coords";
	}

	if(!isset($coords)){
		die("$meg\n$meg_h\n");
	}
	if(isset($dotplot) && (!isset($ref) || !isset($multiFasta))){
		die("$meg\n$meg_h\n");
	}
	if(isset($showMultiFASTA) && !isset($multiFasta)){
		die("$meg\n$meg_h\n");
	}
	
	if(in_array("-p", $argv)){
		$printWhile = 1;
	}
	else{
		$printWhile = 0;
	}


	//================================================
	// deal with .coords file
	//================================================
	$arr = file($coords, FILE_IGNORE_NEW_LINES);
	if($arr[1] == "NUCMER"){
		$method = "nucmer";
	}
	else if($arr[1] == "PROMER"){
		$method = "promer";
	}
	else{
		$method = "nucmer";
	}
	for($i = 0; $i < 5; $i++){
		array_shift($arr);
	}
	$lines = array();
	foreach($arr as $k => $line){
		$element = preg_split("/ +/", trim($line));
		$num = count($element);
		$lines[$k][0] = $element[0]; //ref_start
		$lines[$k][1] = $element[1]; //ref_end
		if($lines[$k][0] > $lines[$k][1]){
			swap($lines[$k][0], $lines[$k][1]);	
		}
		$lines[$k][3] = $element[3]; //que_start
		$lines[$k][4] = $element[4]; //que_end
		if($lines[$k][3] > $lines[$k][4]){
			swap($lines[$k][3], $lines[$k][4]);	
		}
		$lines[$k][6] = $element[6]; //ref_len
		$lines[$k][7] = $element[7]; //que_len
		$lines[$k][$num-3] = $element[$num-3]; //ref_frm
		$lines[$k][$num-2] = $element[$num-2]; //que_frm
		list($dump, $lines[$k][$num-1]) = preg_split("/\t/", $element[$num-1]);


	}

	//according to ref order
	//sort by ref
	$line_num = count($lines);
	for($i = 0; $i < $line_num; $i++){
		for($j = $i+1; $j < $line_num; $j++){
			if($lines[$i][0] > $lines[$j][0]){
				swap($lines[$i], $lines[$j]);
			}
			else if($lines[$i][0] == $lines[$j][0]){
				if($lines[$i][1] > $lines[$j][1]){
					swap($lines[$i], $lines[$j]);
				}
			}
		}
	}

	//marker number
	for($i = 0; $i < $line_num; $i++){
		if($lines[$i][$num-3] * $lines[$i][$num-2] > 0){
			$lines[$i][8] = $i+1;
		}
		else{
			$lines[$i][8] = -($i+1);
		}
	}

	//record marker length
	for($i = 0; $i < $line_num; $i++){
		$marker_len[$lines[$i][8]] = $lines[$i][7];
	}


	//sort by contig
	for($i = 0; $i < $line_num; $i++){
		for($j = $i+1; $j < $line_num; $j++){
			if(strcmp($lines[$i][$num-1], $lines[$j][$num-1]) > 0){
				swap($lines[$i], $lines[$j]);
			}
			if($lines[$i][$num-1] == $lines[$j][$num-1]){
				if($lines[$i][3] > $lines[$j][3]){
					swap($lines[$i], $lines[$j]);
				}
				else if($lines[$i][3] == $lines[$j][3]){
					if($lines[$i][4] > $lines[$j][4]){
						swap($lines[$i], $lines[$j]);
					}
				}
			}
		}
	}

	$temp = "";
	$contigData = "";
	$tag = array();
	for($i = 0; $i < $line_num; $i++){
		if($lines[$i][$num-1] != $temp){
			$contigData .= ">".$lines[$i][$num-1]."\n";
			array_push($tag, trim(">".$lines[$i][$num-1]));
		}
		$contigData .= $lines[$i][8]."\n";

		$temp = $lines[$i][$num-1];
	}

	// shuffle the contigs orders
	$order = explode(">", $contigData);
	if(isset($random_order)){
		shuffle($order);
	}
	if(isset($reverse_order)){
		$reverse_order = array();
		$reverse_order_rest = array();
		$answer_order = file($answer, FILE_IGNORE_NEW_LINES);
		foreach($order as $line){
			$flag = 0;
			foreach($answer_order as $k => $each){
				if($each == "-----" || substr($each, 0, 1) == ">" || trim($each) == "") continue;
				if(substr($line, 0, strpos($line, "\n")) == substr($each, 0, strpos($each, " "))){
					//	array_unshift($reverse_order, $line);
					$reverse_order[$k] = $line;
					$flag = 1;
					break;
				}
			}
			if($flag == 0){
				array_unshift($reverse_order_rest, $line);
			}
		}
		$order = $reverse_order;
		ksort($order);
		$order = array_merge($order, $reverse_order_rest);
		$order = array_reverse($order);
	}
	$new = "";
	foreach($order as $each){
		if($each == "") continue;
		$new .= ">".$each;
	}
	$contigData = $new;
	file_put_contents("$coords.contig", $contigData); 

	$line = explode("\n", trim($contigData));
	$markers_tmp = "";
	$marker_pool = "";
	foreach($line as $each){
		if($each == "") continue;
		if(strstr($each, ">")){
			$marker_pool .= str_replace(" ", "__", $each)."\n";
			continue;
		}
		$markers_tmp .= $each."\n";
		$marker_pool .= $each."\n";
	}
	$markers_arr = preg_split("/[\s,]+/", trim($markers_tmp));
	$markers_pool_arr = preg_split("/[\s,]+/", trim($marker_pool));

	$markers = array();
	foreach($markers_arr as $each){
		array_push($markers, abs($each));
	}

	if(max($markers) != count($markers)){
		die("There has some missing marker(s) in your input.\n");
	}
/*
	$markers_input = "";
	foreach($markers_pool_arr as $each){
		if(strstr($each, ">")){
			$markers_input .= str_replace("__", " ", $each)."\n";
			continue;
		}
		$markers_input .= $each."\n";
	}
	*/
}

//==================================== load contigs

//$printWhile = 1;
$markers_input = "$coords.contig";
$conNum = 0;
$total = 0;
$contig = array();
$contigBegin = array();
$contigEnd = array();
$contigSet = file_get_contents($markers_input);
$contigSet = explode(">", $contigSet);

foreach($contigSet as $each){
	if($each == "") continue;
	$conNum++;
	$contig_tmp = explode("\n", trim($each));
	$contigTag[$contig_tmp[1]] = $contig_tmp[0];
	$contigTag[$contig_tmp[count($contig_tmp)-1]] = $contig_tmp[0];
	array_push($contigBegin, $contig_tmp[1]);
	array_push($contigEnd, $contig_tmp[count($contig_tmp)-1]);
	array_shift($contig_tmp);
	$total += count($contig_tmp);
	array_push($contig, $contig_tmp);
}
$inputCom = range(1,$total);

if(isset($unmappedFile)){
	$unmappedContigs = "";
	$draftContig = file_get_contents($multiFasta);
	$draftContig = explode(">", $draftContig);
	foreach($draftContig as $eachInDraft){
		$toBeTok = $eachInDraft;
		$contigNameInD = strtok($toBeTok, " \n");
		foreach($contigSet as $eachInContig){
			$contigNameInC = strtok($eachInContig, " \n");
			if($contigNameInD == $contigNameInC){
				$unmapped = 0;
				break;
			}
			else{
				$unmapped = 1;
			}
		}
		if($unmapped == 1){
			$unmappedContigs .= ">".$eachInDraft;
		}
	}
	file_put_contents("unmapped_contigs.fna", $unmappedContigs);
}
//====================================
// 1. add caps
//====================================
$n = count($contig);
$m = count($inputCom);

// capping sigma
for($i=1;$i<=$n;$i++){
	$j = $i-1;
	if($i == 1){
		$capInputCom[$j] = $inputCom;
		array_unshift($capInputCom[$j],$m+1);
		array_push($capInputCom[$j],$m+2);
		continue;
	}
	$capInputCom[$j] = array($m+$i*2-1, $m+$i*2);
}
$max = $m+$n*2;

// add minus strand
$capInputCom = addMinusStrand($capInputCom);

// capping pi
$C5 = array();
$NC3 = array();
for($i=1;$i<=$n;$i++){
	$j = $i-1;
	$cap_pi[$j] = $contig[$j];
	array_unshift($cap_pi[$j],$m+$i*2-1);
	array_push($cap_pi[$j],$m+$i*2);
	array_push($C5, $m+$i*2-1); // marking C5
	array_push($C5, ($m+$i*2)*-1); // marking C5
	array_push($NC3, $m+$i*2); // marking N3 or C3
	array_push($NC3, ($m+$i*2-1)*-1); // marking N3 or C3
}

// add minus strand
$cap_pi = addMinusStrand($cap_pi);

//====================================
// 2. get sigma-pi inverse
//====================================
foreach($cap_pi as $k => $eachCap_pi){
	$reverCap_pi[$k] = array_reverse($eachCap_pi);
}
$sigma_pi = product($capInputCom, $reverCap_pi); // capped sigma and capped pi inverse

if($printWhile == 1){
	print "sigma_pi:\n";
	print_r($sigma_pi);
}

if(isset($countDist)){
	$rearrangeDist = ($max*2 - count($sigma_pi))/2;
	print "Rearrangement distance: $rearrangeDist\n";
	file_put_contents("dist.txt", "Rearrangement distance: $rearrangeDist\n");
}
//====================================
// 3. cap exchange
//====================================
$i = 0;
$skip_cycle = array();
$char = array();
$contigNum = array();
foreach($cap_pi as $i => $each){
	$eachNum = count($each);
	foreach($each as $j => $gene){
		if($j == 0){
			$char[$gene] = "C5";
		}
		else if($j == 1){
			$char[$gene] = "T";
		}
		else if($j == count($each)-1){
			$char[$gene] = "C3";
		}
		else{
			$char[$gene] = "O";
		}
		$contigNum[$gene] = $i;
	}
}

do{
	$i++;
	$exit = 1;
	if($printWhile == 1) print "in while #3\n";
	foreach($sigma_pi as $k => $cycle){
		if(count($cycle) < 2 || in_array($cycle, $skip_cycle)) continue;
		for($m=0;$m<count($cycle);$m++){ // loop for x
			$x = $cycle[$m];
			if($char[$x] == "C5" || $char[$x] == "O"){
				array_push($skip_cycle, $cycle);
				continue;
			}
			for($n=1;$m+$n<count($cycle);$n++){ // loop for y
				$y = $cycle[$m+$n];
				if($char[$y] == "C5" || $char[$y] =="O"){
					array_push($skip_cycle, $cycle);
					continue;
				}
				if(ifCEpair($char[$x], $char[$y])){ // x = $cycle[$m], y = $cycle[$m+$n]
					$exit = 0;
					if($printWhile == 1){
						print "x: $x y: $y\n";
					}
				
					$x_5cap = $cap_pi[$contigNum[$x]][0];
					$y_5cap = $cap_pi[$contigNum[$y]][0];
					
					$R_x = pi_gamma($x, $cap_pi);
					$R_y = pi_gamma($y, $cap_pi);
					$R_x_5cap = pi_gamma($x_5cap, $cap_pi);
					$R_y_5cap = pi_gamma($y_5cap, $cap_pi);

					if($char[$x] == "T" || $char[$y] == "T"){
						$swapTmp = $cap_pi[$contigNum[$x]][0];	
						$cap_pi[$contigNum[$x]][0] = $cap_pi[$contigNum[$y]][0];
						$cap_pi[$contigNum[$y]][0] = $swapTmp;
						
						$contigNum[$cap_pi[$contigNum[$x]][0]] = $contigNum[$y];
						$contigNum[$cap_pi[$contigNum[$y]][0]] = $contigNum[$x];
						
						$geneNum_m_x = count($cap_pi[$contigNum[$x*-1]]);
						$geneNum_m_y = count($cap_pi[$contigNum[$y*-1]]);
						
						$swapTmp = $cap_pi[$contigNum[$x*-1]][$geneNum_m_x-1];	
						$cap_pi[$contigNum[$x*-1]][$geneNum_m_x-1] = $cap_pi[$contigNum[$y*-1]][$geneNum_m_y-1];
						$cap_pi[$contigNum[$y*-1]][$geneNum_m_y-1] = $swapTmp;
						
						$contigNum[$cap_pi[$contigNum[$x*-1]][$geneNum_m_x-1]] = $contigNum[$y*-1];
						$contigNum[$cap_pi[$contigNum[$y*-1]][$geneNum_m_y-1]] = $contigNum[$x*-1];
					}
					else if($char[$x] == "C3" || $char[$y] == "C3" || $char[$x] == "N3" || $char[$y] == "N3"){
						$geneNum_p_x = count($cap_pi[$contigNum[$x]]);
						$geneNum_p_y = count($cap_pi[$contigNum[$y]]);
					
						$swapTmp = $cap_pi[$contigNum[$x]][$geneNum_p_x-1];	
						$cap_pi[$contigNum[$x]][$geneNum_p_x-1] = $cap_pi[$contigNum[$y]][$geneNum_p_y-1];
						$cap_pi[$contigNum[$y]][$geneNum_p_y-1] = $swapTmp;
						
						$swapNum = $contigNum[$x];
						$contigNum[$x] = $contigNum[$y];
						$contigNum[$y] = $swapNum;
						
						$swapTmp = $cap_pi[$contigNum[$x*-1]][0];
						$cap_pi[$contigNum[$x*-1]][0] = $cap_pi[$contigNum[$y*-1]][0];
						$cap_pi[$contigNum[$y*-1]][0] = $swapTmp;
					
						$swapNum = $contigNum[$x*-1];
						$contigNum[$x*-1] = $contigNum[$y*-1];
						$contigNum[$y*-1] = $swapNum;
					}
					$sigma_pi = _split($sigma_pi, array($x, $y));
					$sigma_pi = _join($sigma_pi, array($x_5cap, $y_5cap));
					$sigma_pi = _split($sigma_pi, array($R_x, $R_y));
					$sigma_pi = _join($sigma_pi, array($R_x_5cap, $R_y_5cap));
					break 3;
				}
			}
		}
	}

}
while($exit == 0);

if($printWhile == 1){
	print "product of #3:\n";
	print_r($sigma_pi);
	print "cap_pi of #3:\n";
	print_r($cap_pi);
	foreach($sigma_pi as $each){
		print "-----------------\n";
		foreach($each as $gene){
			print $gene." ".$char[$gene]."\n";
		}
	}
	print "-----------------\n";
}

// extract (T, C3) pair
$TC3 = array();
foreach($sigma_pi as $each){
	$TExist = 0;
	$C3Exist = 0;
	foreach($each as $k=>$gene){
		if($char[$gene] == "T"){
			$TExist = 1;
			$T_element = $gene;
		}
		if($char[$gene] == "C3"){
			$C3Exist = 1;
			$C3_element = $gene;
		}
	}
	if($TExist == 1 && $C3Exist == 1){
		array_push($TC3, array($T_element, $C3_element));
	}
}

if($printWhile == 1){
	print "TC3 pairs:\n";
	print_r($TC3);
}

//====================================
// 4. find consecutive m-1 fusions
//====================================
$i = 0;
$skip_cycle = array();
$cycle_index = array();
foreach($cap_pi as $k => $each){
	foreach($each as $gene){
		$cycle_index[$gene] = $k;
	}
}

do{
	$cycle_index = array();
	foreach($cap_pi as $k => $each){
		foreach($each as $gene){
			$cycle_index[$gene] = $k;
		}
	}

	$exit = 1;
	if($printWhile == 1) print "in while #4-1\n";
	foreach($sigma_pi as $cycle){
		if(count($cycle) < 2 || $char[$cycle[0]] == "C5" ||in_array($cycle, $skip_cycle)) continue;
		for($m=0;$m<count($cycle);$m++){ // loop for x
			$x = $cycle[$m];
			if($char[$x] != "T"){
				array_push($skip_cycle, $cycle);
				continue;
			}

			if($m+1 == count($cycle)){
				$y = $cycle[0];
			}
			else{
				$y = $cycle[$m+1];
			}

			if($char[$y] != "C3"){
				array_push($skip_cycle, $cycle);
				continue;
			}
			if($cycle_index[$x] == $cycle_index[$y] || $cycle_index[$y] == -1) continue;
			$cycle_index[$y] = -1;
				$i++;

				$exit = 0;
				$x_5cap = _5cap($x, $cap_pi);
				$y_5cap = _5cap($y, $cap_pi);

				$R_x = pi_gamma($x, $cap_pi);
				$R_y = pi_gamma($y, $cap_pi);
				$R_x_5cap = pi_gamma($x_5cap, $cap_pi);
				$R_y_5cap = pi_gamma($y_5cap, $cap_pi);

				$cap_pi_temp = _join(array($x, $y), $cap_pi);
				$cap_pi_temp = _split(array($x_5cap, $y_5cap), $cap_pi_temp);
				$cap_pi_temp = _join(array($R_y, $R_x), $cap_pi_temp);
				$cap_pi = _split(array($R_y_5cap, $R_x_5cap), $cap_pi_temp);

				$char[$x] = "O";
				$char[$y] = "N3";
				$char[$R_x] = "O";
				$char[$R_y] = "N3";
				
				$sigma_pi = _split($sigma_pi, array($x, $y));
				$sigma_pi = _split($sigma_pi, array($x_5cap, $y_5cap));
				$sigma_pi = _split($sigma_pi, array($R_x, $R_y));
				$sigma_pi = _split($sigma_pi, array($R_x_5cap, $R_y_5cap));
				break 2;
		}
	}
}
while($exit == 0);
$goodFusion = $i;

// deal with good fusion
//$findSmallBegin = 1;
$order_pi_goodFusion = array();
$rev_cap_pi = array();
$used_contig = array();
$num_rotatable = 0;
$num_unrotatable = 0;
$scaffold_log = "";
for($j=0;$j<count($cap_pi);$j++){
	$eachNum = count($cap_pi[$j]);
	if($eachNum <= 2) continue;
	$rev_cap_pi[$j] = array_reverse($cap_pi[$j]);
	foreach($rev_cap_pi[$j] as $key => $element){
		$rev_cap_pi[$j][$key] = $element*-1;
	}

	if(!in_array($cap_pi[$j], $used_contig) && !in_array($rev_cap_pi[$j], $used_contig)){
		array_push($used_contig, $rev_cap_pi[$j]);

		for($i=0;$i<$eachNum;$i++){
			if($char[$cap_pi[$j][$i]] == "C5"){
				$each = rotate_toBegin($cap_pi[$j], $i);
				array_shift($each);
				//check wether the contig could be rotated
				$unrotatable = 0;
				$tag_flag1 = isset($contigTag[$each[0]]) ? $contigTag[$each[0]] : $contigTag[$each[0]*-1];
				$tag_flag2 = isset($contigTag[$each[$eachNum-3]]) ? $contigTag[$each[$eachNum-3]] : $contigTag[$each[$eachNum-3]*-1];
				if(!in_array(array($each[0], $each[$eachNum-2]), $TC3) || $tag_flag1 == $tag_flag2){
					$unrotatable = 1;
					$contig_tag = isset($contigTag[$each[0]]) ? $contigTag[$each[0]] : $contigTag[$each[0]*-1];
					$scaffold_log .= "unrotatable: ".$contig_tag."\n";
					$num_unrotatable++;
				}
				else{
					$contig_tag = isset($contigTag[$each[0]]) ? $contigTag[$each[0]] : $contigTag[$each[0]*-1];
					$scaffold_log .= "rotatable: ".$contig_tag."\n";
					$num_rotatable++;
				}
				array_pop($each); //pop C3
				//============================ reverse scaffold to plus direction
				$plus_num = 0;
				$minus_num = 0;
				foreach($each as $block){
					if($block < 0){
						$minus_num++;
					}
					else{
						$plus_num++;
					}
				}
				if($minus_num > $plus_num){
					$rev_each = array_reverse($each);
					foreach($rev_each as $rev_k => $rev_block){
						$rev_each[$rev_k] = $rev_block*-1;
					}
					$each = $rev_each;
				}

				//===========================
				// find the smallest marker
				//===========================
				if($unrotatable == 0){
					$total_SmallBegin = find_SmallBegin($each);
					unset($SmallB_arr);
					foreach($each as $k => $marker){
						if(isset($each[$k+1])){
							$smallB = $total_SmallBegin;
							if($smallB >= 0){
								$SmallB_arr = rotate_toBegin($each, $smallB);
							}
							else{
								$SmallB_arr = rotate_toEnd($each, $smallB*-1);
							}
							break;
						}
					}
					if(isset($SmallB_arr)){
						array_push($order_pi_goodFusion, $SmallB_arr);
					}
					else{
						array_push($order_pi_goodFusion, $each);
					}
				}
				else{
					array_push($order_pi_goodFusion, $each);
				}
				break;
			}
		}
	}
}

$scaffold_log .= "num_rotatable: $num_rotatable\n"."num_unrotatable: $num_unrotatable\n";
file_put_contents("scaffold_log.".substr($method, 0, 3), $scaffold_log);

$plus_o = "0";
$minus_o = "1";
$already = array();
$mergeContig_tmp = "";
$marker_tag = "";
foreach($order_pi_goodFusion as $i => $each){
	if(isset($already[abs($each[0])]) || isset($already[abs($each[count($each)-1])])) continue;
	$already[abs($each[0])] = 1;
	$scafNum = $i+1;
	$mergeContig_tmp .= "> Scaffold_$scafNum\n";
	$marker_tag .= "> Scaffold_$scafNum\n";
	$temp = "";
	foreach($each as $k => $block){
		if(isset($contigTag[$block]) && $contigTag[$block] != $temp){
			$mergeContig_tmp .= $contigTag[$block]." $plus_o\n";
			$marker_tag .= str_pad($block, 8).str_pad($marker_len[$block], 10).$contigTag[$block]."\n";
			$temp = $contigTag[$block];
		}
		else if(isset($contigTag[$block*-1]) && $contigTag[$block*-1] != $temp){
			$mergeContig_tmp .= $contigTag[$block*-1]." $minus_o\n";
			$marker_tag .= str_pad($block, 8).str_pad($marker_len[$block*-1], 10).$contigTag[$block*-1]."\n";
			$temp = $contigTag[$block*-1];
		}
		else if(isset($marker_len[$block])){
			$marker_tag .= str_pad($block, 8).str_pad($marker_len[$block], 10)."...\n";
		}
		else if(isset($marker_len[$block*-1])){
			$marker_tag .= str_pad($block, 8).str_pad($marker_len[$block*-1], 10)."...\n";
		}
	}
	//	$mergeContig_tmp .= "-----------------------------------\n";
	$mergeContig_tmp .= "\n";
	$marker_tag .= "\n";
}
$mergeContig_tmp = trim($mergeContig_tmp);
if(strstr($markers_input, "txt")){
	$outputFile = str_replace("fastalike", "assembly", $markers_input);
}
else{
	$outputFile = substr($markers_input, 0, -7).".car";
}

if(strstr($outputFile, "/")){
	$outputFile = substr($outputFile, strrpos($outputFile, "/")+1);
}

file_put_contents($outputFile, $mergeContig_tmp);
file_put_contents("$outputFile.marker_tag", $marker_tag);
if($printWhile == 1){
	$order_pi = array();
	foreach($cap_pi as $each){
		$eachNum = count($each);
		if($eachNum > 2){
			for($i=0;$i<$eachNum;$i++){
				if($char[$each[$i]] == "C5"){
					$each = rotate_toBegin($each, $i);
					array_shift($each);
					array_pop($each);
					$order_pi = $each;
					break 2;
				}
			}
		}
	}

	print "capping pi of #4:\n";
	print_r($cap_pi);

	print "sigma_pi of #4:\n";
	print_r($sigma_pi);

	print "order(pi) of #4:\n";
	print_r($order_pi);
}

//====================================
// 5. output
//====================================
if(isset($showMultiFASTA)){
//	$contig_source = "../contig_source";
	$contig_source = "contig_source";
	parse_contig($contig_source, $multiFasta);
	$list = file($coords.".car");
	$fasta = "";
	foreach($list as $each){
		if(strstr($each, ">") || $each == "\n") continue;
		$partEach = substr($each, 0, strpos($each," ")+1);
		foreach($tag as $eachTag){
			if($eachTag == "") continue;
			$eachTag = $eachTag." ";
			if(substr($eachTag, 0, strpos($eachTag, " ")+1) == ">".$partEach){
				$thisTag = trim($eachTag);
				break;
			}
		}
		$partEach = trim($partEach);
		if(trim(substr($each, -2)) == $plus_o){
			$rewrite = $thisTag."\n".file_get_contents("$contig_source/".$partEach);
			$fasta .= $rewrite;
		}
		else{
			$rewrite = $thisTag."\n".file_get_contents("$contig_source/".$partEach.".reverse");
			$fasta .= $rewrite;
		}
	}
	file_put_contents($coords.".car.assembled_fasta.fna", $fasta);
}

if(isset($dotplot)){
	$assembFile = "";
	$prefix = ".";
	$assembled_fasta = $coords.".car.assembled_fasta.fna";
	$draft_assembly = $coords.".car";
	system("$method $prefix/$ref $prefix/$assembled_fasta -p $prefix/plotInput");
	system("delta-filter -1 $prefix/plotInput.delta > $prefix/plotInput.filter");
	system("show-coords -l -d $prefix/plotInput.filter > $prefix/plotInput.coords");
	$direct = judge_dir("$prefix/plotInput.coords");
	if($direct == "-1"){
		$list = file($draft_assembly);
		$list = array_reverse($list);
		$list_r = array();
		$fasta = "";
		foreach($list as $each){
			if(trim($each) == "") continue;
			if(strstr($each, ">")){
				if(!strstr($each, "\n")){
					$each .= "\n";
				}
				array_push($list_r, $each);
				continue;
			}
			$partEach = substr($each, 0, strpos($each," ")+1);
			foreach($tag as $eachTag){
				$eachTag = $eachTag." ";
				if(substr($eachTag, 0, strpos($eachTag, " ")+1) == ">".$partEach){
					$thisTag = trim($eachTag);
					break;
				}
			}
			$partEach = trim($partEach);
			if(trim(substr($each, -2)) == $minus_o){
				$rewrite = $thisTag."\n".file_get_contents("$contig_source/".$partEach);
				$fasta .= $rewrite;
				array_push($list_r, str_replace(" $minus_o\n", " $plus_o\n", $each));
			}
			else{
				$rewrite = $thisTag."\n".file_get_contents("$contig_source/".$partEach.".reverse");
				$fasta .= $rewrite;
				array_push($list_r, str_replace(" $plus_o\n", " $minus_o\n", $each));
			}
		}

		$replace_posi = 0;
		$flag = 0;
		foreach($list_r as $k => $each){
			if(substr($each, 0, 1) == ">"){
				if($replace_posi == 0){ // the first tag
					$first_tag = $each;
					if(!isset($list_r[$k+1])){
						array_unshift($list_r, $first_tag);
						array_pop($list_r);
						$flag = 1;
					}
					$replace_posi = $k;
					continue;
				}
				$list_r[$replace_posi] = $list_r[$k]; // replace
				$replace_posi = $k;
			}
		}
		if($flag == 0){
			array_unshift($list_r, $first_tag);
		}
		foreach($list_r as $each){
			$assembFile .= $each;
		}
		// deal with marker tag
		$marker_lines = explode("\n", $marker_tag);
		$marker_lines = array_reverse($marker_lines);
		$tag_flag = 0;
		$replace_posi = 0;
		$marker_tag_reverse = array();
		foreach($marker_lines as $k => $line){
			if(trim($line) == "") continue;
			if(substr($line, 0, 1) == ">"){
				if($replace_posi == 0){
					array_unshift($marker_tag_reverse, $line."\n");
					$replace_posi = $k;
				}
				else{
					$marker_tag_reverse[$replace_posi] = "\n$marker_lines[$k]\n";
					$replace_posi = $k;
				}
				continue;
			}
			$each = preg_split("/ +/", $line);
			if($each[2] != "..."){ 
				if($tag_flag == 1){ // tag to "..."
					$marker_tag_reverse[$k] = str_pad($each[0]*-1, 8).str_pad($each[1], 10)."...\n"; // tag appears in the last marker
				}
				else if($tag_flag == 0){ // tag to tag
					$marker_tag_reverse[$k] = str_pad($each[0]*-1, 8).str_pad($each[1], 10)."$each[2]\n"; // tag appears within a marker 
				}
				$tag_flag = 0; // means that markers within a tag is finished, ready to put the next tag 
			}
			else if($tag_flag == 0){ // "..." to tag
				if(isset($contigTag[$each[0]])){
					$marker_tag_reverse[$k] = str_pad($each[0]*-1, 8).str_pad($each[1], 10).$contigTag[$each[0]]."\n";
				}
				else{
					$marker_tag_reverse[$k] = str_pad($each[0]*-1, 8).str_pad($each[1], 10).$contigTag[$each[0]*-1]."\n";
				}
				$tag_flag = 1; // means that tag is put
			}
			else{ // "..." to "..."
				$marker_tag_reverse[$k] = str_pad($each[0]*-1, 8).str_pad($each[1], 10)."...\n";
			}
		}
		$marker_tag_reverse_all = "";

		$i = 0;
		foreach($marker_tag_reverse as $each){
			if(isset($marker_tag_reverse[$i])){
				$marker_tag_reverse_all .= $marker_tag_reverse[$i];
			}
			$i++;
		}

		file_put_contents($draft_assembly.".reverse", $assembFile);
		file_put_contents($draft_assembly.".marker_tag.reverse", "$marker_tag_reverse_all");
		file_put_contents($assembled_fasta, $fasta);
		system("$method $prefix/$ref $prefix/$assembled_fasta -p $prefix/plotInput");
	}
	/*
	   system("mummerplot -f --png $prefix/plotInput.delta -p $prefix/dotplot_after_assembly");
	   $gpFile = file_get_contents("$prefix/dotplot_after_assembly.gp");
	   $gp = str_replace("800,800", "1000,800", $gpFile);
	   $gp = str_replace("\"QRY\"\n", "\"Assembly\"\n", $gp);
	   file_put_contents("$prefix/dotplot_after_assembly.gp", $gp);
	   system("gnuplot $prefix/dotplot_after_assembly.gp &> /dev/null &");
	 */
	system("mummerplot -f --large --png $prefix/plotInput.delta -p $prefix/$draft_assembly".".dotplot_HR");
	$gpFile = file_get_contents("$prefix/$draft_assembly".".dotplot_HR.gp");
	$gp = str_replace(" tiny ", " large ", $gpFile);
	$gp = str_replace("1400,1400", "1600,1400", $gp);
	$gp = str_replace("\"QRY\"\n", "\"Assembly\"\n", $gp);
	file_put_contents("$prefix/$draft_assembly".".dotplot_HR.gp", $gp);
	system("gnuplot $prefix/$draft_assembly".".dotplot_HR.gp");
	$path_suffix = str_replace("/", "_", substr(getcwd(),strpos(getcwd(),"NC")));
	//	$path_suffix = str_replace("/", "_", getcwd());
}
//====================================
// functions
//====================================
function swap(&$a, &$b){
	$temp = $a;
	$a = $b;
	$b = $temp;
}

function randomCut($inputGen){
	do{
		$cutpoints = array_rand($inputGen, rand(1, count($inputGen)));
	}
	while((is_array($cutpoints) && in_array(0, $cutpoints)) || $cutpoints === 0);

	if(!is_array($cutpoints)){
		$cutpoints = array($cutpoints);
	}
	array_unshift($cutpoints, 0); // add 0 at begin
	sort($cutpoints);

	$frag = array();
	foreach($cutpoints as $k => $point){
		if($k == count($cutpoints)-1){ // the last one
			$frag[$k] = array_slice($inputGen, $point);
		}
		else{
			$frag[$k] = array_slice($inputGen, $point, $cutpoints[$k+1]-$point);
		}
	}
	return $frag;
}

function addMinusStrand($arr){
	foreach($arr as $contig){
		$arr2 = array();
		foreach($contig as $gene){
			array_push($arr2, $gene*-1);
		}
		$arr2 = array_reverse($arr2);
		array_push($arr, $arr2);
	}
	return $arr;
}

function complete($a){
	global $max;

	$i = 0;
	foreach($a as $contig){
		foreach($contig as $gene){
			$exist[$i] = $gene;
			$i++;
		}
	}
// for positive strand
	for($j=1;$j<=$max;$j++){
		if(in_array($j, $exist)){
			continue;
		}
		else{
			array_push($a, array($j));
		}
	}
// for minus strand
	for($j=-1;$j>=$max*-1;$j--){
		if(in_array($j, $exist)){
			continue;
		}
		else{
			array_push($a, array($j));
		}
	}
	return $a;
	
}

function _split($a, $b){
	global $printWhile;

	if($printWhile == 1){
		print "in split\n";
		print_r($a);
		print_r($b);
	}

	if(!is_array($a[0])){
		foreach($b as $n => $each){
			$k1 = array_search($a[0], $each);
			if($k1 === false) continue;

			$new_arr = rotate_toBegin($each, $k1);
			$k2 = array_search($a[1], $new_arr);
			$part1 = array_slice($new_arr, 0, $k2);
			$part2 = array_slice($new_arr, $k2);
			array_splice($b, $n, 1, array($part1, $part2));
			break;
		}
	}
	else{
		$temp = $a;
		$a = $b;
		$b = $temp;
		foreach($b as $n => $each){
			$k1 = array_search($a[0], $each);
			if($k1 === false) continue;
			
			$new_arr = rotate_toEnd($each, $k1);
			$k2 = array_search($a[1], $new_arr);
			$part1 = array_slice($new_arr, 0, $k2+1);
			$part2 = array_slice($new_arr, $k2+1);
			array_splice($b, $n, 1, array($part1, $part2));
			break;
		}
		
	}

	if($printWhile == 1){
		print_r($b);
	}
	return $b;
}

function _join($a, $b){
	global $printWhile;

	if($printWhile == 1){
		print "in join\n";
		print_r($a);
		print_r($b);
	}

	if(!is_array($a[0])){
		foreach($b as $n => $each){
			$temp_k1 = array_search($a[0], $each);
			if($temp_k1 !== false){
				$n1 = $n;
				$k1 = $temp_k1;
			}
			$temp_k2 = array_search($a[1], $each);
			if($temp_k2 !== false){
				$n2 = $n;
				$k2 = $temp_k2;
			}

			if(isset($n1) && isset($n2)){
				$new_arr1 = rotate_toBegin($b[$n1], $k1);
				$new_arr2 = rotate_toBegin($b[$n2], $k2);
				$join_arr = array_merge($new_arr1, $new_arr2);
				break;
			}
		}
		$join_arr = array($join_arr);
		foreach($b as $n => $each){
			if($n == $n1 || $n == $n2) continue;
			array_push($join_arr, $each);
		}
	}
	else{
		$temp = $a;
		$a = $b;
		$b = $temp;
		foreach($b as $n => $each){
			$temp_k1 = array_search($a[0], $each);
			if($temp_k1 !== false || array($a[0]) == $each){
				$n1 = $n;
				$k1 = $temp_k1;
			}
			$temp_k2 = array_search($a[1], $each);
			if($temp_k2 !== false || array($a[1]) == $each){
				$n2 = $n;
				$k2 = $temp_k2;
			}

			if(isset($n1) && isset($n2)){
				$new_arr1 = rotate_toEnd($b[$n1], $k1);
				$new_arr2 = rotate_toEnd($b[$n2], $k2);
				$join_arr = array_merge($new_arr1, $new_arr2);
				break;
			}
		}
		$join_arr = array($join_arr);
		foreach($b as $n => $each){
			if($n == $n1 || $n == $n2) continue;
			array_push($join_arr, $each); 		
		}
		
	}
	if($printWhile == 1){
		print_r($join_arr);
	}
	return $join_arr;
}

function rotate_toBegin($b, $k){
	$n = count($b);
	$new_arr = array();
	for($i=0;$i<$n;$i++){
		if($k+$i >= $n){
			$new_arr[$i] = $b[$k+$i-$n];
		}
		else{
			$new_arr[$i] = $b[$k+$i];
		}
	}
	return $new_arr;
}

function rotate_toEnd($b, $k){
	$n = count($b);
	$new_arr = array();
	for($i=0;$i<$n;$i++){
		if($k+$i+1 >= $n){
			$new_arr[$i] = $b[$k+$i+1-$n];
		}
		else{
			$new_arr[$i] = $b[$k+$i+1];
		}
	}
	return $new_arr;
}
function product($a, $b){
	global $printWhile;
	$a = complete($a);
	$b = complete($b);
	
	if($printWhile == 1){	
		print "in product a:\n";
		print_r($a);
		print "in product b:\n";
		print_r($b);
	}

	$toSelf = array();
	$temp = array();
	foreach($b as $i => $m){
		$toSelf[$i] = $m;
		// map to itself
		array_shift($toSelf[$i]);
		array_push($toSelf[$i],$m[0]);
		foreach($toSelf[$i] as $j => $n){
			foreach($a as $k => $o){
				$key = array_search($n, $o);
				if($key !== FALSE){
					if(isset($o[$key+1])){
						$temp[$i][$j] = $o[$key+1];
					}
					else{
						$temp[$i][$j] = $o[0]; // to the begin, cuz the circularity.
					}
				}
			}
		}
	}
	$merge_b = merge($b);
	$merge_temp = merge($temp);

	// generate the product
	$prod = array();
	$temp_product = array();
	$i = 0;
	$k = 0;
	$flag = array();
	while($i<count($merge_b)){
		if(isset($flag[$i]) && $flag[$i] == 1){
			if($temp_product != array()){
				$prod[$k] = $temp_product;
				$temp_product = array();
				$k++;
			}
			$i++;
			continue;
		}
		array_push($temp_product, $merge_temp[$i]);
		$flag[$i] = 1;
		$i = array_search($merge_temp[$i], $merge_b);
	}
	$prod = complete($prod);
	if($printWhile == 1){
		print "product:\n";
		print_r($prod);
	}
	return $prod;
}

function merge($array){
	$merge = array();
	foreach($array as $i){
		$merge = array_merge($merge, $i);
	}
	return $merge;
}

function char($a, $b){
	global $total;
	global $C5, $NC3;
	$k = 0;
	$i = 0;
	foreach($b as $each){
		if(abs($each) <= $total){
			$k++;
		}
	}
	// check whether $a in $b
	if(in_array($a, $b)){
		$ainb = 1;
	}
	else
		$ainb = 0;
	// find C5 in $b
	foreach($b as $key => $each){
		if(in_array($each, $C5)){
			$b_C5 = $key;
		}
	}
	if(isset($b_C5)){
		$b_C5 = isset($b[$b_C5+1]) ? $b_C5+1 : 0;
	}
	// C5
	if($ainb == 1 && in_array($a, $C5)){
		$c = "C5";
	}
	// C3
	else if($k != 0 && $ainb == 1 && in_array($a, $NC3)){
		$c = "C3";
	}
	// N3
	else if($k == 0 && $ainb == 1 && in_array($a, $NC3)){
		$c = "N3";
	}
	// T
	else if($k != 0 && isset($b_C5) && $a == $b[$b_C5]){
		$c = "T";
	}
	// O
	else{
		$c = "O";
	}

	return $c;
}

function ifCEpair($a, $b){
	$CEpair = array(array("C3", "C3"),
					array("C3", "N3"),
					array("N3", "C3"),
					array("T", "T"),
					array("T", "N3"),
					array("N3", "T"),
					array("N3", "N3"));
	if(in_array(array($a, $b), $CEpair)){
		return 1;
	}
	else
		return 0;
}
function ifTC3pair($a, $b){
	$TC3pair = array(array("T", "C3"));
	if(in_array(array($a, $b), $TC3pair)){
		return 1;
	}
	else
		return 0;
}

function _5cap($a, $b){
	global $total, $C5, $char;

	foreach($b as $i){
		if(in_array($a, $i)){
			foreach($i as $j){
				if(in_array($j, $C5)){
					return $j;
				}
			}
		}
	}
	return -1;
}

function pi_gamma($gene, $cap_pi){
	foreach($cap_pi as $contig){
		$k = array_search($gene*-1, $contig);
		if($k !== false){
			if(isset($contig[$k+1])){
				return $contig[$k+1];
			}
			else{
				return $contig[0]; // at the begin of the cycle
			}
		}
	}
}

function getMicrotime(){
	list($usec, $sec) = explode(' ', microtime());
	return ((double)$usec + (double)$sec);
}

function find_LIS($arr){
	$array_length = count($arr); 
	$q = array();
	for($a=0;$a<$array_length;$a++){
		$LIS_length = 0;
		for($b=0;$b<$a;$b++){
			if($arr[$a] > $arr[$b]){
				if($q[$b] > $LIS_length){
					$LIS_length = $q[$b];
				}
			}
		}
		$q[$a] = $LIS_length+1;
	}
	$LIS_length = 0;
	for($c=0;$c<$array_length;$c++){
		if($q[$c] > $LIS_length){
			$LIS_length = $q[$c];
		}
	}
	return $LIS_length;
}

function find_breakPoint($arr){
	$BPCount = 0;
	foreach($arr as $k => $marker){
		if(isset($arr[$k+1]) && $marker+1 != $arr[$k+1]){
			$BPCount++;
		}
	}
	return $BPCount;
}

function find_BInAns($contigTag, $arr, $answer){
	$lines = file($answer, FILE_IGNORE_NEW_LINES);
	foreach($lines as $line){
		if($line == "-----" || substr($line, 0, 1) == ">") continue;
		foreach($arr as $k => $each){
			if(isset($contigTag[$each])){
				$tag = $contigTag[$each];
			}
			else if(isset($contigTag[-$each])){
				$tag = $contigTag[-$each];
			}
			else{
				continue;
			}
			if(strstr($line, $tag)){
				return $k;
			}
		}
	}
}

function find_SmallBegin($arr){
	global $contigBegin;
	global $contigEnd;
	$smaller = 999999;
	foreach($arr as $k => $marker){
		if(abs($marker) < $smaller){
			if(in_array($marker, $contigBegin)){
				$smaller = abs($marker);
				$smaller_k = $k;

			}
			else if(in_array($marker*-1, $contigEnd)){
				$smaller = abs($marker);
				$smaller_k = $k;
			}
		}
	}

	return $smaller_k;
}

function judge_dir($coords){
	$arr = file($coords, FILE_IGNORE_NEW_LINES);
	for($i = 0; $i < 5; $i++){
		array_shift($arr);
	}
	$lines = array();
	foreach($arr as $k => $line){
		$element = preg_split("/ +/", trim($line));
		$num = count($element);
		$lines[$k][7] = $element[7]; //que_len
		$lines[$k][$num-3] = $element[$num-3]; //ref_frm
		$lines[$k][$num-2] = $element[$num-2]; //que_frm

	}
	$line_num = count($lines);
	$forward_len = 0;
	$reverse_len = 0;
	for($i = 0; $i < $line_num; $i++){
		if($lines[$i][$num-3] * $lines[$i][$num-2] > 0){
			$forward_len += $lines[$i][7];
		}
		else{
			$reverse_len += $lines[$i][7];
		}
	}
	if($forward_len > $reverse_len){
		return 1;
	}
	else{
		return -1;
	}
}

function parse_contig($contig_file, $multiFasta){
/*
	if(file_exists($contig_file)){
		return 0;
	}
 */
	@mkdir($contig_file);
	$lines = file($multiFasta, FILE_IGNORE_NEW_LINES);
	$forward = "";
	$reverse = "";
	$pass = 0;
	foreach($lines as $k => $line){
		if($line == "") continue;
		if(!strstr($line, ">")){
			$forward = $forward.$line."\n";
			$reverse = strrev($line)."\n".$reverse;
		}
		if(strstr($line, ">") || !isset($lines[$k+1])){
			if($pass == 1){
				file_put_contents("$contig_file/$fileName", $forward);
				$new_reverse = $reverse;
				for($i = 0; $i < strlen($reverse); $i++){
					if($reverse[$i] == "A"){
						$new_reverse[$i] = "T";
					}
					else if($reverse[$i] == "T"){
						$new_reverse[$i] = "A";
					}
					else if($reverse[$i] == "C"){
						$new_reverse[$i] = "G";
					}
					else if($reverse[$i] == "G"){
						$new_reverse[$i] = "C";
					}
				}
				file_put_contents("$contig_file/$fileName.reverse", $new_reverse);
				$forward = "";
				$reverse = "";
			}
			if(strstr($line, " ")){
				$fileName = substr($line, 1, strpos($line, " ")-1);
			}
			else{
				$fileName = substr($line, 1);
			}
			$pass = 1;
		}
			
	}
}

?>
